 IF  EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[TRG_RC_CLI_CONV_RC_CLI_INCLUI_PENDENCIA]'))
	DROP TRIGGER [dbo].[TRG_RC_CLI_CONV_RC_CLI_INCLUI_PENDENCIA]
GO

SET ANSI_NULLS ON
GO 
SET QUOTED_IDENTIFIER ON
GO
 
-------------------------------------INSERO EM RC_VD_CONV--------------------------------------  
CREATE TRIGGER [dbo].[TRG_RC_CLI_CONV_RC_CLI_INCLUI_PENDENCIA] ON [dbo].[RC_VD_CONV] FOR INSERT,UPDATE AS  
begin  
   
 DECLARE @CD_CTR INT  
 DECLARE @CD_EMP INT  
 DECLARE @CD_CLI INT  
 DECLARE @CD_CONV INT  
   
 DECLARE @CD_CLI_DEPEND INT  
 DECLARE @CD_TITULAR INT  
 DECLARE @DATA DATETIME   
    
 SET NOCOUNT ON  
  
/*******************************************************************************************************************/  
Create table #tmpCliConv (CD_EMP int,CD_CLI int, CD_CONV  int);  
  
 INSERT INTO #tmpCliConv  
 SELECT   
  CD_EMP,  
  CD_CLI,  
  CD_CONV   
 FROM   
  INSERTED;  
 INSERT INTO #tmpCliConv  
 SELECT   
  D.CD_EMP,D.CD_CLI,D.CD_CONV   
 FROM   
  DELETED D  
  LEFT JOIN #tmpCliConv c ON   
  d.cd_emp= c.cd_emp and  
  d.cd_cli= c.cd_cli  
 where  
  c.cd_emp is null;  
  
/*******************************************************************************************************************/  
  
 DECLARE Vendas CURSOR FAST_FORWARD FOR   
 SELECT CD_EMP,CD_CLI,CD_CONV   
  FROM #tmpCliConv  
  
 OPEN Vendas  
 FETCH NEXT FROM Vendas INTO @CD_EMP,@CD_CLI,@CD_CONV  
 WHILE @@FETCH_STATUS=0  
  Begin  
        
   IF NOT EXISTS (SELECT TOP 1 RC_CLI_CONV_DEPENDENTE.CD_CLI_TITULAR AS CD_CLI_TITULAR   
        FROM RC_CLI_CONV_DEPENDENTE WHERE CD_CLI_DEPEND = @CD_CLI)  
    BEGIN   
     SET @CD_TITULAR = @CD_CLI  
    END  
   ELSE  
    BEGIN   
     SET @CD_TITULAR = (SELECT TOP 1 RC_CLI_CONV_DEPENDENTE.CD_CLI_TITULAR AS CD_CLI_TITULAR FROM RC_CLI_CONV_DEPENDENTE WHERE CD_CLI_DEPEND = @CD_CLI)   
    END   
      -------------------------------------------------------------------------------------------------      
   IF NOT EXISTS(SELECT * FROM   
       RC_CLI_CONV_RC_CLI_SALDO_PENDENTE     
       WHERE   
        CD_EMP=@CD_EMP  
        AND CD_CLI= @CD_TITULAR   
        AND CD_CONV = @CD_CONV )  
          
   BEGIN  
    INSERT INTO RC_CLI_CONV_RC_CLI_SALDO_PENDENTE ( CD_EMP,   
                 CD_CLI,  
                 CD_CONV,   
                 DT_CAD)  
    SELECT     
        @CD_EMP  AS CD_EMP,   
        @CD_TITULAR AS CD_CLI,   
        @CD_CONV AS CD_CONV,   
        GETDATE()   
      FROM RC_CLI_CONV_RC_CLI   
        WHERE CD_EMP=@CD_EMP  
       AND CD_CLI= @CD_TITULAR   
       AND CD_CONV = @CD_CONV ;  
   END  
   -------------------------------------------------------------------------------------------------       
   DECLARE Dependente CURSOR FAST_FORWARD FOR   
    SELECT DISTINCT  
       d.CD_EMP  
     , d.CD_CLI_DEPEND  
     , GETDATE()  
    FROM  
     RC_CLI_CONV_DEPENDENTE d   
     JOIN RC_CLI_CONV_RC_CLI C ON   
     D.CD_EMP  = C.CD_EMP AND   
     D.CD_CONV  = C.CD_CONV AND   
     D.CD_CLI_DEPEND = C.CD_CLI  
    WHERE   
      d.CD_CLI_TITULAR = @CD_TITULAR  
     AND d.CD_CONV = @CD_CONV;  
  
   OPEN Dependente  
   FETCH NEXT FROM Dependente INTO @CD_EMP, @CD_CLI_DEPEND, @DATA  
   WHILE @@FETCH_STATUS=0  
    Begin   
     IF NOT EXISTS (SELECT * FROM RC_CLI_CONV_RC_CLI_SALDO_PENDENTE with(nolock)  
          WHERE CD_EMP=@CD_EMP AND CD_CLI=@CD_CLI_DEPEND)  
          
      BEGIN      
       INSERT INTO RC_CLI_CONV_RC_CLI_SALDO_PENDENTE (CD_EMP, CD_CLI, CD_CONV, DT_CAD)   
        VALUES (@CD_EMP, @CD_CLI_DEPEND, @CD_CONV, @DATA)        
      END  
                
     --Proximo registro  
     FETCH NEXT FROM Dependente INTO @CD_EMP, @CD_CLI_DEPEND, @DATA  
    End  
  
    --Fechando cursos  
    CLOSE Dependente;  
    --Desalocando cursos da memoria  
    DEALLOCATE Dependente;    
       
   FETCH NEXT FROM vendas INTO @CD_EMP,@CD_CLI, @CD_CONV  
  End  
  
 CLOSE Vendas;  
 DEALLOCATE Vendas;  
  
/*******************************************************************************************************************/  
/*  
 DELETE   
  P  
 FROM  
  RC_DEB_POSICAO_FINANCEIRA_PROCESSAR_RC_VD_CONV p   
  INNER JOIN INSERTED i ON  
  p.CD_EMP = i.CD_EMP AND  
  p.CD_FILIAL = i.CD_FILIAL  
 WHERE  
  p.DT_PROC >= CONVERT(DATE,i.DT_VD);  
  
   
/*******************************************************************************************************************/  
 --Caso nao tenha cadastre  
 INSERT INTO RC_DEB_POSICAO_FINANCEIRA_PROCESSAR_RC_VD_CONV(CD_EMP  
                , CD_FILIAL  
                , DT_PROC  
                , DT_CAD  
                )  
 SELECT DISTINCT  
   CD_EMP  
  , CD_FILIAL  
  , MIN(CONVERT(DATE, i.DT_VD))  
  , GETDATE()  
 FROM  
  INSERTED I  
 GROUP BY  
   CD_EMP  
   , CD_FILIAL;  
   */  
end  